<?php

/************************************************************************/
/* NUKEDONWLOAD                                                         */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Courtois Olivier (webmaster@nukedownload.com)  */
/* http://www.nukedownload.com                                          */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

class ND_Field {
		var $title;
		var $columName;
		var $value;
		var $startFontTag; // insert Tag before the field  ex:    <b>[Field]</b>
		var $endFontTag;   // insret Tag after the field         Start       End
		
				
			
		function show() {
			echo "&nbsp;";	
		}
		// Start Font Tag
		function setStartFontTag($tag) {
			$this->startFontTag=$tag;	
		}
		// End Font Tag
		function setEndFontTag($tag) {
			$this->endFontTag= $tag;	
		}
		// TITLE
		function setTitle($t) {
			$this->title=$t;
		}
		function getTitle() {
			return $this->title;	
		}
		
		//VALUE $Value Must be a array of SqlResult
		function setValue($value) {
				$this->value = $value;
		}
		
		function getValue() {
			 return $this->value;
		}
		// COLUMN NAME
		function setColumnName($col) {
			$this->columName= $col;
		}
		function getColumnName() {
			return $this->columName;
		}
		
		
					
	}

/*****************************/
/*  CLASS LABEL              */
/*****************************/

class ND_Label extends ND_Field {	
		function show() {
			echo $this->value[$this->columName];
		}
		function edit() {
			echo $this->value[$this->columName];
			}
	}
	
/*****************************/
/*  CLASS TextField          */
/*****************************/

class ND_TextField extends ND_Field {
		
		var $size;
		var $maxlength;
		
		function ND_TextField() {
			$this->size="30";
			$this->maxlength="30";	
		}
		
		function show() {
			echo $this->value[$this->columName];
		}
		
		function edit() {
			$size="";
			if($this->size!="") {
				$size=" size=\"".$this->size."\"";	
			}
			if ($this->maxlength!="") {
				$size .=" maxlength=\"".$this->maxlength."\"";	
			} else if ($this->size!="") {
				$size .=" maxlength=\"".$this->size."\"";	
			}
			echo "<INPUT name=\"".$this->columName."\" type=Text $size value=\"".$this->value[$this->columName]."\">";
		}
		// SIZE
		function setSize($size) {
			$this->size=$size;	
		}
		// MAXLENGTH
		function setMaxLength($max) {
			$this->maxlength=$max;	
		}
	
	}
/*****************************/
/*  CLASS TextHidden         */
/*****************************/

class ND_TextHidden extends ND_Field {
		function edit() {
			echo "<INPUT TYPE=\"HIDDEN\" name=\"".$this->columName."\" value=\"".$this->value[$this->columName]."\">";
		}
}

/*****************************/
/*  CLASS Image              */
/*****************************/

class ND_Image extends ND_Field {
	function show() {
	 echo "<IMG SRC=\"";
	 echo $this->value[$this->columName];
	 echo "\">";	
	}	
}
/*****************************/
/*  CLASS TextArea           */
/*****************************/

class ND_TextArea extends ND_Field {
		var $rows; // Number of line in textArea
		var $cols; // number of columns in textArea
		
		function ND_TextArea() {
			$this->rows="10"; 
			$this->cols="40";
		}
		
		function show() {
			echo $this->value[$this->columName];
		}
		
		function edit() {
			echo "<textarea name=\"".$this->columName."\" rows=\"".$this->rows."\" cols=\"".$this->cols."\">".$this->value[$this->columName]."</textarea>";
			}
	
	}

/*****************************/
/*  CLASS CheckBox           */
/*****************************/

class ND_CheckBox extends ND_Field {
		function show() {
			echo $this->value[$this->columName];
		}
		
		function edit() {
			if ($this->value[$this->columName]=="Y") {
				echo "<input type=\"checkbox\" name=\"".$this->columName."\" VALUE=\"".$this->value[$this->columName]."\" checked>";
			}
			else {
				echo "<input type=\"checkbox\" name=\"".$this->columName."\" VALUE=\"".$this->value[$this->columName]."\" >";
			}
		}
	
}

/*****************************/
/*  CLASS COMBO              */
/*****************************/

class ND_Combo extends ND_Field {
		var $SQLQuery;
		var $dbi;
		
		// SQL Query
		function setSqlQuery($query) {
			$this->SQLQuery = $query;
		}
		// DatabaseInstance
		function setDatabase($dbi) {
			$this->dbi =$dbi;
		}
		
		// SHOW
		function show() {
			echo $this->value[$this->columName];
		}
		// EDIT
		function edit() {
			$result = sql_query($this->SQLQuery, $this->dbi);
			echo "<SELECT name=\"".$this->columName."\">\n";
			if (sql_num_rows($result, $this->$dbi)>0) {
				while (list($key,$value)= mysql_fetch_array($result)) {
					if ($key==$this->value[$this->columName]) {
					echo "<OPTION value=\"".$key."\" selected>".$value."</OPTION>\n";	
					} else {
					echo "<OPTION value=\"".$key."\">".$value."</OPTION>\n";	
					}
				}
			
			}
			echo "</SELECT>";
		}
	
}


?>