<?php
/************************************************************************/
/* NUKEDONWLOAD                                                         */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Courtois Olivier (webmaster@nukedownload.com)  */
/* http://www.nukedownload.com                                          */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


/*****************************************/
/* CLASS ROW									  */
/*													  */
/* Description: Show a HTML ROW IN TABLE */
/*****************************************/

class ND_Row {
	
	var $fields; // Array of ND_Field
	var $value; //  mysql_fetch_array Result
	var $PrimaryKey; // must be a ND_Fields array
	var $urlAction;
	var $actionvalue;
	
	// FIELDS
	function setFields($arrayofND_Field) {
		$this->fields = $arrayofND_Field;
	  while (list($key)=each($this->fields)) {
			if ($this->fields[$key]->getColumnName()=="") {
			  $this->fields[$key]->setColumnName($key);
			}
		}
		reset($this->fields);
	}
	function getFields() {
		return $this->fields; 	
	}
	// VALUE
	function setValue($Sqlresult) {
		$this->value= $Sqlresult;
		if (is_array($this->fields)) {
					while (list($key)=each($this->fields)) {
							$this->fields[$key]->setValue($Sqlresult);
					}
					reset($this->fields);
		}
		else {
			echo "ERROR in  NB_Row->show() Variable $this->fields must be an array Of ND_Fields";
		}	
	}
	function getValue() {
		return $this->value;	
	}
	// Key
	function setKey($value) {
				$this->PrimaryKey = $value;
		}
	function getKey() {
			return $this->PrimaryKey;
		}
	// URL Action
	function setAction($value) {
			$this->urlAction =$value;
	}
	// ActionValue
	function setActionValue($value) {
		$this->actionvalue =$value;	
	}
	
	/*=============================================*/	
	/*  FUNCTION SHOW                              */
	/*=============================================*/
	
	function show() {
		echo "<TR>\n";
					if (is_array($this->fields)) {
						while (list($key)=each($this->fields)) {							
			 				echo "<TD>";
			 				if (get_class($this->fields[$key])=="nd_link") {
			 					// URL
			 					$fieldValue= $this->value[$this->fields[$key]->getColumnName()];
			 					$this->fields[$key]->setValue($fieldValue);
			 					// ND FIELD
			 					$myField = $this->fields[$key]->getField();
			 					$myField->setValue($this->value[$myField->getColumnName()]);
			 					$this->fields[$key]->setField($myField);
			 					$this->fields[$key]->show();
			 				} else {
			 					$fieldValue= $this->value[$this->fields[$key]->getColumnName()];
			 					$this->fields[$key]->setValue($fieldValue);
			 					$this->fields[$key]->show();
			 					}
			 				echo "</TD>\n";
						}
					reset($this->fields);
					} else {
						echo "ERROR in  NB_Row->show() Variable $this->fields must be an array";
					}			
		echo "</TR>\n";
	}
	
	/*=============================================*/	
	/*  FUNCTION EDIT                              */
	/*=============================================*/
	
	function edit() {
		// FORM AND TABLE
		echo "<FORM ACTION=\"".$this->urlAction."\" method=\"POST\">\n";
		echo "<TABLE BORDER=\"0\" WIDTH=\"90%\">\n";
		if (is_array($this->fields)) {
			
			while (list($key)=each($this->fields)) {
			 echo "<TR>";
			 echo "<TD>".$this->fields[$key]->getTitle()."</TD>";
			 echo "<TD>";
			 echo $this->fields[$key]->edit();
			 echo "</TD>";
			 echo "</TR>\n";
			}
		}
		else {
			echo "ERROR in  NB_Table->Edit() Variable Fields must be an array\n";
		}
		
		echo "</TABLE>\n";
		if ($this->actionvalue) {
		echo "<BR><input type=\"submit\" value=\"".$this->actionvalue."\">\n";
		} else {
		echo "<BR><input type=\"submit\"  value=\"Submit\">\n";
		}
		echo "</FORM>\n";
	}
}

/****************************************/
/* CLASS TABLE									 */
/*													 */
/* Description: Show a HTML Table       */
/****************************************/


class ND_Table {
	var $SQLQuery;
	var $dbi;
	var $row;
	var $header;
	var $border;
	var $width;
	var $rowbypage;
	var $headerTag;
	var $tableTag;
	var $name;
	
	/* ----------------- CONSTRUCTOR --------------*/
	function ND_Table() {
		$this->width ="90%";
		$this->rowbypage=10;
		$this->pageid=0;
		$this->name="tablename";
	}
	
	/* ----------------- ACCESSOR --------------*/
	
	//name
	function setName($name) {
		$this->name=$name;	
	}
	
	// Row
	function setRow($ndrow) {
		$this->row = $ndrow;	
	}
	// SQL Query
	function setSqlQuery($query) {
			$this->SQLQuery = $query;
		}
	// DatabaseInstance
	function setDatabase($dbi) {
			$this->dbi =$dbi;
		}
	// Header $value = array("colonne1","colonne2")
	function setHeader($value) {
			$this->header= $value;
		}
	// setBorder
	function setBorder($border) {
		$this->border = $border;
	}
	// set Width
	function setWidth($width) {
		$this->width=$width;	
	}
	// set RowByPage
	function setRowByPage($nb) {
		$this->rowbypage=$nb;	
	}
	
	//set headerTag
	function setHeaderTag($tag) {
		$this->headerTag=$tag;	
	}
	//set TableTag
	function setTableTag($tag) {
		$this->tableTag=$tag;	
	}
	
	/*=============================================*/	
	/*  FUNCTION SHOW                              */
	/*=============================================*/
	function show() {
		// CALCUL PAGEID
		$querystring= "http://".$_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		$a = split('&', $querystring);
		$i = 0;
		$pageid=1;
		while ($i < count ($a)) {
		    $b = split ('=', $a [$i]);
		    if ($b[0]==$this->name."_page" && $b[1]!="") {
			   $pageid=$b[1];
		    }
		    $i++;
		}
		if ($pageid<1) {$this->pageid=1;}
		$offset=($pageid-1)*$this->rowbypage;
  		
 	
  		// CALCUL ROWCOUNT
  		$result = sql_query(eregi_replace("select(.*)from","select count(*) from",$this->SQLQuery),$this->dbi);
  		$rowcount= mysql_fetch_array($result);
  		
		//TABLE
		$result = sql_query($this->SQLQuery." limit $offset,$this->rowbypage", $this->dbi);
		if ($this->tableTag!="")	 {
		echo "<CENTER><TABLE ".$this->tableTag.">\n";
		} else {
		echo "<CENTER><TABLE NAME=\"".$this->name."\" WIDTH=\"".$this->width."\" BORDER=\"".$this->border."\">\n";
		}
		if ($this->header!="") {
			echo "<TR>\n";
			while (list($key,$value)=each($this->header)) {
								if ($this->headerTag!="") {
									echo "<TH ".$this->headerTag.">";
								} else
								{
			 					echo "<TH>";
			 					}
			 					echo $value;
			 					echo "</TH>\n";
			}
			echo "</TR>\n";
			reset($this->header);
		}
	
		if (sql_num_rows($result, $dbi)>0) {
			// FETCH ROW	
			while ($row= mysql_fetch_array($result)) {
					$this->row->setValue($row);
					$this->row->show();
			}
		}
		
		echo "</TABLE></CENTER>\n";
		echo "<BR>\n";
		$pagenumber=floor($rowcount[0]/$this->rowbypage);
		if (($rowcount[0] % $this->rowbypage)>0) $pagenumber=$pagenumber+1;
		if ($pagenumber>1) {
			echo "<CENTER><TABLE WIDTH=\"".$this->width."\" BORDER=\"0\">\n";
			echo "<TR><TD ALIGN=\"CENTER\">";
			$i=1;
			$urlpage=eregi_replace("&".$this->name."_page=[0-9]+","",$querystring);
			if ($pageid>1) {
				echo "<A HREF=\"".htmlspecialchars($urlpage."&".$this->name."_page=".($pageid-1))."\"><IMG BORDER=0 SRC=\"./images/download/left.gif\"></A>&nbsp;&nbsp;&nbsp;&nbsp;";
			}
			while($i< $pagenumber+1) {
				if ($i!=$pageid) {
					echo "<A HREF=\"".htmlspecialchars($urlpage."&".$this->name."_page=".$i)."\">[".$i."]</A>&nbsp;&nbsp;\n";
				} else {
					echo "[".$pageid."]&nbsp;&nbsp;";
				}
				$i++;
			}
			if ($pageid<$pagenumber) {
					echo "<A HREF=\"".htmlspecialchars($urlpage."&".$this->name."_page=".($pageid+1))."\"><IMG BORDER=0 SRC=\"./images/download/right.gif\"></A>&nbsp;&nbsp;&nbsp;&nbsp;";
			}
			echo "<TD></TR>\n";
			echo "</TABLE></CENTER>\n";
		}
		
	
		
		
	}
	
	
}




?>