<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!defined('MODULE_FILE')) {
	die("You can't access this file directly...");
}
require_once("mainfile.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$pagetitle = "- "._SURVEYS."";

function format_url($comment) {
    global $nukeurl;
    unset($location);
    $links = array();
    $hrefs = array();
    $pos = 0;
    while (!(($pos = strpos($comment,"<",$pos)) === false)) {
	$pos++;
	$endpos = strpos($comment,">",$pos);
	$tag = substr($comment,$pos,$endpos-$pos);
	$tag = trim($tag);
	if (isset($location)) {
    	    if (!strcasecmp(strtok($tag," "),"/A")) {
        	$link = substr($comment,$linkpos,$pos-1-$linkpos);
        	$links[] = $link;
        	$hrefs[] = $location;
        	unset($location);
    	    }
	    $pos = $endpos+1;
	} else {
	    if (!strcasecmp(strtok($tag," "),"A")) {
		if (eregi("HREF[ \t\n\r\v]*=[ \t\n\r\v]*\"([^\"]*)\"",$tag,$regs));
		else if (eregi("HREF[ \t\n\r\v]*=[ \t\n\r\v]*([^ \t\n\r\v]*)",$tag,$regs));
		else $regs[1] = "";
		if ($regs[1]) {
	    	    $location = $regs[1];
		}
		$pos = $endpos+1;
		$linkpos = $pos;
	    } else {
		$pos = $endpos+1;
	    }
	}
    }
    for ($i=0; $i<sizeof($links); $i++) {
	if (!stripos_clone($hrefs[$i], "http://")) {
	    $hrefs[$i] = $nukeurl;
	} elseif (!stripos_clone($hrefs[$i], "mailto://")) {
	    $href = explode("/",$hrefs[$i]);
	    $href = " [$href[2]]";
	    $comment = str_replace(">$links[$i]</a>", "title='$hrefs[$i]'> $links[$i]</a>$href", $comment);
	}
    }
    return($comment);
}

function modone() {
	global $admin, $moderate, $module_name;
	if(((isset($admin)) && ($moderate == 1)) || ($moderate==2)) echo "<form action=\"modules.php?name=$module_name&file=comments\" method=\"post\">";
}

function modtwo($tid, $score, $reason) {
	global $admin, $user, $moderate, $reasons;
	if((((isset($admin)) && ($moderate == 1)) || ($moderate == 2)) && ($user)) {
		echo " | <select name=dkn$tid>";
		for($i=0; $i<sizeof($reasons); $i++) {
			echo "<option value=\"$score:$i\">$reasons[$i]</option>\n";
		}
		echo "</select>";
	}
}

function modthree($pollID, $mode, $order, $thold=0) {
	global $admin, $user, $moderate;
	if((((isset($admin)) && ($moderate == 1)) || ($moderate==2)) && ($user)) echo "<center><input type=hidden name=pollID value=$pollID><input type=hidden name=mode value=$mode><input type=hidden name=order value=$order><input type=hidden name=thold value=$thold>
	<input type=hidden name=op value=moderate>
	<input type=image src=images/menu/moderate.gif border=0></form></center>";
}

function navbar($pollID, $title, $thold, $mode, $order) {
    global $user, $bgcolor1, $bgcolor2, $textcolor1, $textcolor2, $anonpost, $pollcomm, $prefix, $db, $module_name;
    OpenTable();
    $pollID = intval($pollID);
    $query = $db->sql_query("SELECT pollID FROM ".$prefix."_pollcomments where pollID='$pollID'");
    if(!$query) $count = 0; else $count = $db->sql_numrows($query);
    $row = $db->sql_fetchrow($db->sql_query("SELECT pollTitle from ".$prefix."_poll_desc where pollID='$pollID'"));
    $title = stripslashes(check_html($row['pollTitle'], "nohtml"));
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }
    echo "\n\n<!-- COMMENTS NAVIGATION BAR START -->\n\n";
    echo "<table width=\"99%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">\n";
    if($title) {
	echo "<tr><td bgcolor=\"$bgcolor2\" align=\"center\"><font class=\"content\" color=\"$textcolor1\">\"$title\" | ";
	    if(is_user($user)) {
		echo "<a href=\"modules.php?name=Your_Account&op=editcomm\"><font color=\"$textcolor1\">"._CONFIGURE."</font></a>";
	    } else {
		echo "<a href=\"modules.php?name=Your_Account\"><font color=\"$textcolor1\">"._LOGINCREATE."</font></a>";
	    }
	    if(($count==1)) {
	        echo " | <B>$count</B> "._COMMENT."</font></td></tr>\n";
	    } else {
	        echo " | <B>$count</B> "._COMMENTS."</font></td></tr>\n";
	    }
    }
    echo "<tr><td bgcolor=\"$bgcolor1\" align=\"center\" width=\"100%\">\n"
	."<form method=\"post\" action=\"modules.php?name=$module_name&op=results&pollID=$pollID\">\n"
	."<font color=\"$textcolor2\">"._THRESHOLD."</font> <select name=\"thold\">\n"
	."<option value=\"-1\"";
    if ($thold == -1) {
	echo " selected";
    }
    echo ">-1</option>\n"
         ."<option value=\"0\"";
    if ($thold == 0) {
	echo " selected";
    }
    echo ">0</option>\n"
	 ."<option value=\"1\"";
    if ($thold == 1) {
	echo " selected";
    }
    echo ">1</option>\n"
	 ."<option value=\"2\"";
    if ($thold == 2) {
	echo " selected";
    }
    echo ">2</option>\n"
	 ."<option value=\"3\"";
    if ($thold == 3) {
	echo " selected";
    }
    echo ">3</option>\n"
	 ."<option value=\"4\"";
    if ($thold == 4) {
	echo " selected";
    }
    echo ">4</option>\n"
	 ."<option value=\"5\"";
    if ($thold == 5) {
	echo " selected";
    }
    echo ">5</option>\n"
	 ."</select> <select name=mode>"
	 ."<option value=\"nocomments\"";
    if ($mode == 'nocomments') {
	echo " selected";
    }
    echo ">"._NOCOMMENTS."</option>\n"
	 ."<option value=\"nested\"";
    if ($mode == 'nested') {
	echo " selected";
    }
    echo ">"._NESTED."</option>\n"
	 ."<option value=\"flat\"";
    if ($mode == 'flat') {
	echo " selected";
    }
    echo ">"._FLAT."</option>\n"
	 ."<option value=\"thread\"";
    if (!isset($mode) || $mode=='thread' || $mode=="") {
	echo " selected";
    }
    echo ">"._THREAD."</option>\n"
	 ."</select> <select name=\"order\">"
	 ."<option value=\"0\"";
    if (!$order) {
	echo " selected";
    }
    echo ">"._OLDEST."</option>\n"
	 ."<option value=\"1\"";
    if ($order==1) {
	echo " selected";
    }
    echo ">"._NEWEST."</option>\n"
    	 ."<option value=\"2\"";
    if ($order==2) {
	echo " selected";
    }
    echo ">"._HIGHEST."</option>\n"
	 ."</select>\n"
	 ."<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n"
	 ."<input type=\"submit\" value=\""._REFRESH."\"></form>\n";
    cookiedecode($user);
    if (($pollcomm) AND ($mode != "nocomments")) {
	if ($anonpost==1 OR (isset($admin) AND is_admin($admin)) OR is_user($user)) {
	    if (!isset($pid)) { $pid = 0; }
	    echo "<form action=\"modules.php?name=$module_name&file=comments\" method=\"post\">"
		."<input type=\"hidden\" name=\"pid\" value=\"$pid\">"
		."<input type=\"hidden\" name=\"pollID\" value=\"$pollID\">"
		."<input type=\"hidden\" name=\"op\" value=\"Reply\">"
		."<input type=\"submit\" value=\""._REPLYMAIN."\"></td></form></tr>";
	}
    }
    echo "<tr><td bgcolor=\"$bgcolor2\" align=\"center\"><font class=\"tiny\">"._COMMENTSWARNING."</font></td></tr>\n"
	  ."</table>"
	  ."\n\n<!-- COMMENTS NAVIGATION BAR END -->\n\n";
    CloseTable();
    if ($anonpost == 0 AND !is_user($user)) {
        echo "<br>";
	OpenTable();
	echo "<center>"._NOANONCOMMENTS."</center>";
	CloseTable();
    }
}

function DisplayKids ($tid, $mode, $order=0, $thold=0, $level=0, $dummy=0, $tblwidth=99) {
	global $datetime, $user, $cookie, $bgcolor1, $reasons, $anonymous, $anonpost, $commentlimit, $prefix, $module_name, $db, $userinfo, $user_prefix;
	$comments = 0;
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }
        $tid = intval($tid);
	$result = $db->sql_query("SELECT tid, pid, pollID, date, name, email, host_name, subject, comment, score, reason from ".$prefix."_pollcomments where pid = '$tid' order by date, tid");
	if ($mode == 'nested') {
		/* without the tblwidth variable, the tables run off the screen with netscape
		   in nested mode in long threads so the text can't be read. */
	while($row = $db->sql_fetchrow($result)) {
                        $r_tid = intval($row['tid']);
                        $r_pid = intval($row['pid']);
                        $r_pollID = intval($row['pollID']);
                        $r_date = $row['date'];
			$r_name = check_words(check_html($row['name'], "nohtml"));
			$r_email = check_words(check_html($row['email'], "nohtml"));
			$r_host_name = check_words(check_html($row['host_name'], "nohtml"));
			$r_subject = stripslashes(check_words(check_html($row['subject'], "nohtml")));
			$r_comment = stripslashes(check_words(check_html($row['comment'], "")));
                        $r_score = intval($row['score']);
                        $r_reason = intval($row['reason']);
			if($r_score >= $thold) {
				if (!isset($level)) {
				} else {
					if (!$comments) {
						echo "<ul>";
						$tblwidth -= 5;
					}
				}
				$comments++;
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = "["._NOSUBJECT."]";
			// enter hex color between first two appostrophe for second alt bgcolor
				$r_bgcolor = ($dummy%2)?"":"#E6E6D2";
				echo "<a name=\"$r_tid\">";
				echo "<table width=90% border=0><tr bgcolor=\"$bgcolor1\"><td>";
				formatTimestamp($r_date);
				if ($r_email) {
					echo "<p><b>$r_subject</b> <font class=content>";
					if($userinfo['noscore'] == 0) {
						echo "("._SCORE." $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br>"._BY." <a href=\"mailto:$r_email\">$r_name</a> <font class=content><b>($r_email)</b></font> "._ON." $datetime";
				} else {
					echo "<p><b>$r_subject</b> <font class=content>";
					if($userinfo['noscore'] == 0) {
						echo "("._SCORE." $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br>"._BY." $r_name "._ON." $datetime";
				}
				if ($r_name != $anonymous) {
				    $row2 = $db->sql_fetchrow($db->sql_query("SELECT user_id FROM ".$user_prefix."_users WHERE username='$r_name'"));
				    $r_uid = intval($row2['user_id']);
				    echo "<BR>(<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$r_name\">"._USERINFO."</a> | <a href=\"modules.php?name=Private_Messages&amp;mode=post&amp;u=$r_uid\">"._SENDAMSG."</a>) ";
				}
				$row_url = $db->sql_fetchrow($db->sql_query("SELECT user_website FROM ".$user_prefix."_users WHERE username='$r_name'"));
				$url = stripslashes($row_url['user_website']);
				if ($url != "http://" AND !empty($url) AND stripos_clone($url, "http://")) { echo "<a href=\"$url\" target=\"new\">$url</a> "; }
				echo "</font></td></tr><tr><td>";
				if((isset($userinfo['commentmax'])) && (strlen($r_comment) > $userinfo['commentmax'])) echo substr($r_comment, 0, $userinfo['commentmax'])."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$r_pollID&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
				elseif(strlen($r_comment) > $commentlimit) echo substr("$r_comment", 0, $commentlimit)."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$r_pollID&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
				else echo $r_comment;
				echo "</td></tr></table><br><p>";
				if ($anonpost==1 OR is_admin($admin) OR is_user($user)) {
				    echo "<font class=content color=\"$bgcolor2\"> [ <a href=\"modules.php?name=$module_name&file=comments&op=Reply&pid=$r_tid&pollID=$r_pollID&mode=$mode&order=$order&thold=$thold\">"._REPLY."</a>";
				}
				modtwo($r_tid, $r_score, $r_reason);
				echo " ]</font><p>";
				DisplayKids($r_tid, $mode, $order, $thold, $level+1, $dummy+1, $tblwidth);
			}
		}
	} elseif ($mode == 'flat') {
	while($row = $db->sql_fetchrow($result)) {
                        $r_tid = intval($row['tid']);
                        $r_pid = intval($row['pid']);
                        $r_pollID = intval($row['pollID']);
                        $r_date = $row['date'];
			$r_name = check_words(check_html($row['name'], "nohtml"));
			$r_email = check_words(check_html($row['email'], "nohtml"));
			$r_host_name = check_words(check_html($row['host_name'], "nohtml"));
			$r_subject = stripslashes(check_words(check_html($row['subject'], "nohtml")));
			$r_comment = stripslashes(check_words(check_html($row['comment'], "")));
                        $r_score = intval($row['score']);
                        $r_reason = intval($row['reason']);
			if($r_score >= $thold) {
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = "["._NOSUBJECT."]";
				echo "<a name=\"$r_tid\">";
				echo "<hr><table width=99% border=0><tr bgcolor=\"$bgcolor1\"><td>";
				formatTimestamp($r_date);
				if ($r_email) {
					echo "<p><b>$r_subject</b> <font class=content>";
					if($userinfo['noscore'] == 0) {
						echo "("._SCORE." $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br>"._BY." <a href=\"mailto:$r_email\">$r_name</a> <font class=content><b>($r_email)</b></font> "._ON." $datetime";
 				} else {
					echo "<p><b>$r_subject</b> <font class=content>";
					if($userinfo['noscore'] == 0) {
						echo "("._SCORE." $r_score";
						if($r_reason>0) echo ", $reasons[$r_reason]";
						echo ")";
					}
					echo "<br>"._BY." $r_name "._ON." $datetime";
				}
				if ($r_name != $anonymous) {
				    $row3 = $db->sql_fetchrow($db->sql_query("SELECT user_id FROM ".$user_prefix."_users WHERE username='$r_name'"));
				    $ruid = intval($row3['user_id']);
				    echo "<BR>(<a href=\"modules.php?name=Your_Account&op=userinfo&username=$r_name\">"._USERINFO."</a> | <a href=\"modules.php?name=Private_Messages&mode=post&u=$ruid\">"._SENDAMSG."</a>) ";
				}
				$row_url2 = $db->sql_fetchrow($db->sql_query("SELECT user_website FROM ".$user_prefix."_users WHERE username='$r_name'"));
				$url = $row_url2['user_website'];
				if ($url != "http://" AND !empty($url) AND eregi("http://", $url)) { echo "<a href=\"$url\" target=\"new\">$url</a> "; }
				echo "</font></td></tr><tr><td>";
				if((isset($userinfo['commentmax'])) && (strlen($r_comment) > $userinfo['commentmax'])) echo substr($r_comment, 0, $userinfo['commentmax'])."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$r_pollID&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
				elseif(strlen($r_comment) > $commentlimit) echo substr("$r_comment", 0, $commentlimit)."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$r_pollID&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
				else echo $r_comment;
				echo "</td></tr></table><br><p><font class=content color=\"$bgcolor2\"> [ <a href=\"modules.php?name=$module_name&file=comments&op=Reply&pid=$r_tid&pollID=$r_pollID&mode=$mode&order=$order&thold=$thold\">"._REPLY."</a>";
				modtwo($r_tid, $r_score, $r_reason);
				echo " ]</font><p>";
				DisplayKids($r_tid, $mode, $order, $thold);
			}
		}
	} else {
	while($row = $db->sql_fetchrow($result)) {
                        $r_tid = intval($row['tid']);
                        $r_pid = intval($row['pid']);
                        $r_pollID = intval($row['pollID']);
                        $r_date = $row['date'];
			$r_name = check_words(check_html($row['name'], "nohtml"));
			$r_email = check_words(check_html($row['email'], "nohtml"));
			$r_host_name = check_words(check_html($row['host_name'], "nohtml"));
			$r_subject = stripslashes(check_words(check_html($row['subject'], "nohtml")));
			$r_comment = stripslashes(check_words(check_html($row['comment'], "")));
                        $r_score = intval($row['score']);
                        $r_reason = intval($row['reason']);
			if($r_score >= $thold) {
				if (isset($level) && !$comments) {
				  echo "<ul>";
				}
				$comments++;
				if (!eregi("[a-z0-9]",$r_name)) $r_name = $anonymous;
				if (!eregi("[a-z0-9]",$r_subject)) $r_subject = "["._NOSUBJECT."]";
				formatTimestamp($r_date);
				echo "<li><font class=\"content\"><a href=\"modules.php?name=$module_name&file=comments&op=showreply&tid=$r_tid&pollID=$r_pollID&pid=$r_pid&mode=$mode&order=$order&thold=$thold#$r_tid\">$r_subject</a> "._BY." $r_name "._ON." $datetime</font><br>";
				DisplayKids($r_tid, $mode, $order, $thold, $level+1, $dummy+1);
			}
		}
	}
	if ($level && $comments) {
		echo "</ul>";
	}

}

function DisplayBabies ($tid, $level=0, $dummy=0) {
	global $userinfo, $datetime, $anonymous, $prefix, $db, $module_name;
	$comments = 0;
        $tid = intval($tid);
	$result = $db->sql_query("SELECT tid, pid, pollID, date, name, email, host_name, subject, comment, score, reason from ".$prefix."_pollcomments where pid = '$tid' order by date, tid");
	while($row = $db->sql_fetchrow($result)) {
                        $r_tid = intval($row['tid']);
                        $r_pid = intval($row['pid']);
                        $r_pollID = intval($row['pollID']);
                        $r_date = $row['date'];
                        $r_name = check_words(check_html($row['name'], "nohtml"));
                        $r_email = check_words(check_html($row['email'], "nohtml"));
                        $r_host_name = check_words(check_html($row['host_name'], "nohtml"));
                        $r_subject = stripslashes(check_words(check_html($row['subject'], "nohtml")));
                        $r_comment = stripslashes(check_words(check_html($row['comment'], "")));
                        $r_score = intval($row['score']);
                        $r_reason = intval($row['reason']);
		if (!isset($level)) {
		} else {
			if (!$comments) {
				echo "<ul>";
			}
		}
		$comments++;
		if (!eregi("[a-z0-9]",$r_name)) { $r_name = $anonymous; }
		if (!eregi("[a-z0-9]",$r_subject)) { $r_subject = "["._NOSUBJECT."]"; }
		formatTimestamp($r_date);
		echo "<a href=\"modules.php?name=$module_name&file=comments&op=showreply&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">$r_subject</a><font class=\"content\"> "._BY." $r_name "._ON." $datetime<br>";
		DisplayBabies($r_tid, $level+1, $dummy+1);
	}
	if ($level && $comments) {
		echo "</ul>";
	}
}

function DisplayTopic ($pollID, $pid=0, $tid=0, $mode="thread", $order=0, $thold=0, $level=0, $nokids=0) {
	global $title, $bgcolor1, $bgcolor2, $bgcolor3, $hr, $user, $datetime, $cookie, $userinfo, $admin, $commentlimit, $anonymous, $reasons, $anonpost, $foot1, $foot2, $foot3, $foot4, $prefix, $module_name, $db, $userinfo, $user_prefix;
	include_once("header.php");
	$count_times = 0;

                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }

	$q = "select tid, pid, pollID, date, name, email, host_name, subject, comment, score, reason from ".$prefix."_pollcomments where pollID='$pollID' and pid='$pid'";
	if(!empty($thold)) {
		$q .= " and score>='$thold'";
	} else {
		$q .= " and score>='0'";
	}
	if ($order==1) $q .= " order by date desc";
	if ($order==2) $q .= " order by score desc";
	$something = $db->sql_query($q);
	$num_tid = $db->sql_numrows($something);
	navbar($pollID, $title, $thold, $mode, $order);
	modone();
	while ($count_times < $num_tid) {
		echo "<br>";
		OpenTable();
		$row_q = $db->sql_fetchrow($something);
		$tid = intval($row_q['tid']);
		$pid = intval($row_q['pid']);
		$pollID = intval($row_q['pollID']);
		$date = $row_q['date'];
		$c_name = check_words(check_html($row_q['name'], "nohtml"));
		$email = check_words(check_html($row_q['email'], "nohtml"));
		$host_name = check_words(check_html($row_q['host_name'], "nohtml"));
		$subject = stripslashes(check_words(check_html($row_q['subject'], "nohtml")));
		$comment = stripslashes(check_words(check_html($row_q['comment'], "")));
		$score = intval($row_q['score']);
		$reason = intval($row_q['reason']);
		if (empty($c_name)) { $c_name = $anonymous; }
		if (empty($subject)) { $subject = "["._NOSUBJECT."]"; }
		echo "<a name=\"$tid\">";
		echo "<table width=99% border=0><tr bgcolor=\"$bgcolor1\"><td width=500>";
		formatTimestamp($date);
		if ($email) {
			echo "<p><b>$subject</b> <font class=content>";
			if($userinfo['noscore'] == 0) {
				echo "("._SCORE." $score";
				if($reason>0) echo ", $reasons[$reason]";
				echo ")";
			}
			echo "<br>"._BY." <a href=\"mailto:$email\">$c_name</a> <b>($email)</b> "._ON." $datetime";
		} else {
			echo "<p><b>$subject</b> <font class=content>";
			if($userinfo['noscore'] == 0) {
				echo "("._SCORE." $score";
				if($reason>0) echo ", $reasons[$reason]";
				echo ")";
			}
			echo "<br>"._BY." $c_name "._ON." $datetime";
		}

    // If you are admin you can see the Poster IP address (you have this right, no?)
    // with this you can see who is flaming you... ha-ha-ha

	$journal = "";
	if (is_active("Journal")) {
	    $row = $db->sql_fetchrow($db->sql_query("SELECT jid from ".$prefix."_journal where aid='$c_name' AND status='yes' order by pdate,jid DESC limit 0,1"));
	    $jid = intval($row['jid']);
	    if (!empty($jid) AND isset($jid)) {
		$journal = " | <a href=\"modules.php?name=Journal&file=display&jid=$jid\">"._JOURNAL."</a>";
	    } else {
		$journal = "";
	    }
	}
		if ($c_name != $anonymous) {
		    $row2 = $db->sql_fetchrow($db->sql_query("SELECT user_id FROM ".$user_prefix."_users WHERE username='$c_name'"));
		    $r_uid = intval($row2['user_id']);
		    echo "<br>(<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$c_name\">"._USERINFO."</a> | <a href=\"modules.php?name=Private_Messages&amp;mode=post&amp;u=$r_uid\">"._SENDAMSG."</a>$journal) ";
		}
		$row_url = $db->sql_fetchrow($db->sql_query("SELECT user_website FROM ".$user_prefix."_users WHERE username='$c_name'"));
		$url = stripslashes($row_url['user_website']);
		if ($url != "http://" AND !empty($url) AND stripos_clone($url, "http://")) { echo "<a href=\"$url\" target=\"new\">$url</a> "; }

		if(is_admin($admin)) {
		    $row3 = $db->sql_fetchrow($db->sql_query("SELECT host_name from ".$prefix."_pollcomments where tid='$tid'"));
		    $host_name = $row3['host_name'];
		    echo "<br><b>(IP: $host_name)</b>";
		}

		echo "</font></td></tr><tr><td>";
		if((isset($userinfo['commentmax'])) && (strlen($comment) > $userinfo['commentmax'])) echo substr("$comment", 0, $userinfo['commentmax'])."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$r_pollID&tid=$r_tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
		elseif(strlen($comment) > $commentlimit) echo substr($comment, 0, $commentlimit)."<br><br><b><a href=\"modules.php?name=$module_name&file=comments&pollID=$pollID&tid=$tid&mode=$mode&order=$order&thold=$thold\">"._READREST."</a></b>";
		else echo $comment;
		echo "</td></tr></table><br><p>";
		if ($anonpost==1 OR is_admin($admin) OR is_user($user)) {
			echo "<font class=\"content\"> [ <a href=\"modules.php?name=$module_name&file=comments&op=Reply&pid=$tid&pollID=$pollID&mode=$mode&order=$order&thold=$thold\">"._REPLY."</a>";
		}
		if ($pid != 0) {
		    $row4 = $db->sql_fetchrow($db->sql_query("SELECT pid from ".$prefix."_pollcomments where tid='$pid'"));
		    $erin = intval($row4['pid']);
			echo "| <a href=\"modules.php?name=$module_name&file=comments&pollID=$pollID&pid=$erin&mode=$mode&order=$order&thold=$thold\">"._PARENT."</a>";
		}
		modtwo($tid, $score, $reason);

		if(is_admin($admin)) {
		    echo " | <a href=\"admin.php?op=RemovePollComment&amp;tid=$tid&amp;pollID=$pollID\">"._DELETE."</a> ]</font><p>";
		} elseif ($anonpost != 0 OR is_admin($admin) OR is_user($user)) {
		    echo " ]</font><p>";
		}

		DisplayKids($tid, $mode, $order, $thold, $level);
		echo "</ul>";
		if($hr) echo "<hr noshade size=1>";
		echo "</p>";
		$count_times += 1;
	    CloseTable();
	}
	modthree($pollID, $mode, $order, $thold);
	if (!isset($subject)) { $subject = ""; }
	if($pid==0) return array($pollID, $pid, $subject);
	else include_once("footer.php");
}

function singlecomment($tid, $pollID, $mode, $order, $thold) {
	include_once("header.php");
	global $userinfo, $user, $cookie, $datetime, $bgcolor1, $bgcolor2, $bgcolor3, $anonpost, $admin, $anonymous, $prefix, $db, $module_name;
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }
        $tid = intval($tid);
        $pollID = intval($pollID);
	$row = $db->sql_fetchrow($db->sql_query("SELECT date, name, email, subject, comment, score, reason from ".$prefix."_pollcomments where tid='$tid' and pollID='$pollID'"));
	$date = $row['date'];
	$name = check_words(check_html($row['name'], "nohtml"));
	$email = check_words(check_html($row['email'], "nohtml"));
	$subject = check_words(check_html($row['subject'], "nohtml"));
	$comment = check_words(check_html($row['comment'], ""));
	$score = intval($row['score']);
	$reason = intval($row['reason']);
	$titlebar = "<b>$subject</b>";
	if(empty($name)) $name = $anonymous;
	if(empty($subject)) $subject = "["._NOSUBJECT."]";
	modone();
	echo "<table width=99% border=0><tr bgcolor=\"$bgcolor1\"><td width=500>";
	formatTimestamp($date);
	if($email) echo "<p><b>$subject</b> <font class=content>("._SCORE." $score)<br>"._BY." <a href=\"mailto:$email\"><font color=\"$bgcolor2\">$name</font></a> <font class=content><b>($email)</b></font> "._ON." $datetime";
	else echo "<p><b>$subject</b> <font class=content>("._SCORE." $score)<br>"._BY." $name "._ON." $datetime";
	echo "</td></tr><tr><td>$comment</td></tr></table><br><p><font class=content color=\"$bgcolor2\"> [ <a href=\"modules.php?name=$module_name&file=comments&op=Reply&pid=$tid&pollID=$pollID&mode=$mode&order=$order&thold=$thold\">"._REPLY."</a> | <a href=\"modules.php?name=$module_name&pollID=$pollID\">"._ROOT."</a>";
	modtwo($tid, $score, $reason);
	echo " ]";
	modthree($pollID, $mode, $order, $thold);
	include_once("footer.php");
}

function reply ($pid, $pollID, $mode, $order, $thold) {
    include_once("header.php");
    global $userinfo, $user, $cookie, $datetime, $bgcolor1, $bgcolor2, $bgcolor3, $AllowableHTML, $anonymous, $prefix, $anonpost, $module_name, $db;
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }
    $pid = intval($pid);
    $pollID = intval($pollID);
    $order = htmlentities($order);
    $thold = htmlentities($thold);
    $mode = htmlentities($mode);
    if ($anonpost == 0 AND !is_user($user)) {
	OpenTable();
	echo "<center><font class=title><b>"._SURVEYCOM."</b></font></center>";
	CloseTable();
	echo "<br>";
	OpenTable();
	echo "<center>"._NOANONCOMMENTS."<br><br>"._GOBACK."</center>";
	CloseTable();
    } else {
	if($pid!=0) {
		list($date, $name, $email, $subject, $comment, $score) = $db->sql_fetchrow($db->sql_query("select date, name, email, subject, comment, score from ".$prefix."_pollcomments where tid='$pid'"));
                $score = intval($score);
	} else {
		list($subject) = $db->sql_fetchrow($db->sql_query("select pollTitle FROM ".$prefix."_poll_desc where pollID='$pollID'"));
	}
	if(empty($comment)) {
	    $comment = $temp_comment;
	}
	$titlebar = "<b>$subject</b>";
	if(empty($name)) $name = $anonymous;
	if(empty($subject)) $subject = "["._NOSUBJECT."]";
	formatTimestamp($date);
	OpenTable();
	echo "<center><font class=\"title\"><b>"._SURVEYCOM."</b></font></center>";
	CloseTable();
	echo "<br>";
	OpenTable();
	echo "<center><font class=\"content\"><b>$subject</b></center><br>";
	if (empty($comment)) {
	    echo "<center><i>"._DIRECTCOM."</i></font></center><br>";
	} else {
	    echo "<br>$comment</font>";
	}
	CloseTable();
	if(!isset($pid) || !isset($pollID)) { echo "Something is not right. This message is just to keep things from messing up down the road"; exit(); }
	if($pid == 0) {
		list($subject) = $db->sql_fetchrow($db->sql_query("select pollTitle from ".$prefix."_poll_desc where pollID='$pollID'"));
	} else {
		list($subject) = $db->sql_fetchrow($db->sql_query("select subject from ".$prefix."_pollcomments where tid='$pid'"));
	}
	echo "<br>";
	OpenTable();
	echo "<form action=\"modules.php?name=$module_name&file=comments\" method=\"post\">";
	echo "<font class=\"content\"><b>"._YOURNAME.":</b></font> ";
	if (is_user($user)) {
		cookiedecode($user);
		echo "<font class=\"content\"><a href=\"modules.php?name=Your_Account\">$cookie[1]</a> [ <a href=\"modules.php?name=Your_Account&amp;op=logout\">"._LOGOUT."</a> ]</font>";
	} else {
		echo "<font class=\"content\">$anonymous</font>";
		$xanonpost=1;
	}
	echo "<br><br><font class=\"content\"><B>"._SUBJECT.":</B></FONT><BR>";
	if (!stripos_clone($subject,"Re:")) $subject = "Re: ".substr($subject,0,81)."";
	echo "<INPUT TYPE=\"text\" NAME=\"subject\" SIZE=50 maxlength=85 value=\"$subject\"><BR>";
	echo "<br><br><font class=\"content\"><B>"._UCOMMENT.":</B></FONT><BR>"
		."<TEXTAREA wrap=virtual cols=50 rows=10 name=comment></TEXTAREA><br>
		<font class=\"content\">"._ALLOWEDHTML."<br>";
		while (list($key,)= each($AllowableHTML)) echo " &lt;".$key."&gt;";
		echo "<br>";
	if (is_user($user) AND ($anonpost == 1)) { echo "<INPUT type=checkbox name=xanonpost> "._POSTANON."<br>"; }
	echo "<INPUT type=\"hidden\" name=\"pid\" value=\"$pid\">"
		."<INPUT type=\"hidden\" name=\"pollID\" value=\"$pollID\">"
		."<INPUT type=\"hidden\" name=\"mode\" value=\"$mode\">"
		."<INPUT type=\"hidden\" name=\"order\" value=\"$order\">"
		."<INPUT type=\"hidden\" name=\"thold\" value=\"$thold\">"
		."<br><INPUT type=submit name=op value=\""._PREVIEW."\"> "
		."<INPUT type=submit name=op value=\""._OK."\"> "
		."<SELECT name=\"posttype\">"
		."<OPTION value=\"exttrans\">"._EXTRANS."</option>"
		."<OPTION value=\"html\" >"._HTMLFORMATED."</option>"
		."<OPTION value=\"plaintext\" SELECTED>"._PLAINTEXT."</option>"
		."</SELECT>"
		."</FORM>";
	CloseTable();
    }
    include_once("footer.php");
}

function replyPreview ($pid, $pollID, $subject, $comment, $xanonpost, $mode, $order, $thold, $posttype) {
	include_once("header.php");
	global $userinfo, $user, $cookie, $AllowableHTML, $anonymous, $module_name;
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }

	$subject = htmlentities(check_words(check_html($subject, "nohtml")), ENT_QUOTES);
	$comment = htmlentities(check_words(check_html($comment)), ENT_QUOTES);
        $pid = intval($pid);
        $pollID = intval($pollID);
	if (!isset($pid) || !isset($pollID)) {
		die(_NOTRIGHT);
	}
	OpenTable();
	echo "<center><font class=\"title\"><b>"._SURVEYCOMPRE."</b></font></center>";
	CloseTable();
	echo "<br>";
	OpenTable();
	echo "<b>$subject</b><br>";
	echo "<font class=content>"._BY." ";
	if (is_user($user)) {
		echo $cookie[1];
	} else {
		echo $anonymous;
	}
	echo _ONN."</font><br><br>";
	if ($posttype=="exttrans") {
	    echo nl2br(htmlspecialchars($comment));
	} elseif ($posttype=="plaintext") {
	    echo nl2br($comment);
	} else {
	    echo $comment;
	}
	CloseTable();
	echo "<br>";
	OpenTable();
	echo "<form action=\"modules.php?name=$module_name&file=comments\" method=\"post\">"
	    ."<font class=\"content\"><B>"._YOURNAME.":</B></FONT> ";
	if (is_user($user)) {
	    echo "<font class=\"content\"><a href=\"modules.php?name=Your_Account\">$cookie[1]</a> <font class=\"content\">[ <a href=\"modules.php?name=Your_Account&op=logout\">"._LOGOUT."</a> ]</font>";
	} else {
	    echo "<font class=\"content\">$anonymous</font>";
	}
	echo "<br><br><font class=\"content\"><B>"._SUBJECT.":</B></FONT><BR>"
		."<INPUT TYPE=\"text\" name=\"subject\" size=\"50\" maxlength=\"85\" value=\"$subject\"><br><br>"
		."<P><font class=\"content\"><B>"._UCOMMENT.":</B></FONT><BR>"
		."<TEXTAREA wrap=\"virtual\" cols=\"50\" rows=\"10\" name=\"comment\">$comment</TEXTAREA><br>";
		echo"<font class=\"content\">"._ALLOWEDHTML."<br>";
		while (list($key,)= each($AllowableHTML)) echo " &lt;".$key."&gt;";
		echo "<br>";		
	if (($xanonpost) AND ($anonpost == 1)) { 
	    echo "<INPUT type=\"checkbox\" name=\"xanonpost\" checked> "._POSTANON."<br>"; 
	} elseif ((is_user($user)) AND ($anonpost == 1)) {
	    echo "<INPUT type=\"checkbox\" name=\"xanonpost\"> "._POSTANON."<br>";
	}
	echo "<INPUT type=\"hidden\" name=\"pid\" value=\"$pid\">"
		."<INPUT type=\"hidden\" name=\"pollID\" value=\"$pollID\"><INPUT type=\"hidden\" name=\"mode\" value=\"$mode\">"
		."<INPUT type=\"hidden\" name=\"order\" value=\"$order\"><INPUT type=\"hidden\" name=\"thold\" value=\"$thold\">"
		."<br><INPUT type=submit name=op value=\""._PREVIEW."\"> "
		."<INPUT type=submit name=op value=\""._OK."\"> <SELECT name=\"posttype\"><OPTION value=\"exttrans\"";
		if($posttype=="exttrans") echo" SELECTED";
		echo  ">"._EXTRANS."<OPTION value=\"html\"";;
		if($posttype=="html") echo" SELECTED";
		echo ">"._HTMLFORMATED."<OPTION value=\"plaintext\"";
		if(($posttype!="exttrans") && ($posttype!="html")) echo" SELECTED";
		echo ">"._PLAINTEXT."</SELECT></FORM>";
    CloseTable();
    include("footer.php");
}

function CreateTopic ($xanonpost, $subject, $comment, $pid, $pollID, $host_name, $mode, $order, $thold, $posttype) {
    global $userinfo, $user, $userinfo, $EditedMessage, $cookie, $prefix, $pollcomm, $anonpost, $db, $module_name;
                  cookiedecode($user);
                  getusrinfo($user);
                  if (!isset($mode) OR empty($mode)) {
                    if(isset($userinfo['umode'])) {
                      $mode = $userinfo['umode'];
                    } else {
                      $mode = "thread";
                    }
                  }
                  if (!isset($order) OR empty($order)) {
                    if(isset($userinfo['uorder'])) {
                      $order = $userinfo['uorder'];
                    } else {
                      $order = 0;
                    }
                  }
                  if (!isset($thold) OR empty($thold)) {
                    if(isset($userinfo['thold'])) {
                      $thold = $userinfo['thold'];
                    } else {
                      $thold = 0;
                    }
                  }
    $author = FixQuotes($author);
    $subject = addslashes(filter_text($subject, "nohtml"));
    $comment = addslashes(format_url(filter_text($comment, "")));
    if ($posttype=="exttrans") {
    	$comment = addslashes(nl2br(htmlspecialchars(check_words($comment))));
    } elseif ($posttype=="plaintext") {
    	$comment = addslashes(nl2br(filter_text($comment)));
    } else {
    	$comment = addslashes(filter_text($comment));
    }
    if(is_user($user)) {
	getusrinfo($user);
    }
    if ((is_user($user)) && (!$xanonpost)) {
    	getusrinfo($user);
	$name = $userinfo['username'];
	$email = $userinfo['femail'];
	$url = $userinfo['user_website'];
	$score = 1;
    } else {
	$name = "";
	$email = "";
	$url = "";
	$score = 0;
    }
    $ip = $_SERVER['REMOTE_HOST'];
    if (empty($ip)) {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    $pollID = intval($pollID);
    $result = $db->sql_query("select count(*) from ".$prefix."_poll_desc where pollID='$pollID'");
    $fake = $db->sql_numrows($result);
    if ($fake == 1) {
	if ((($anonpost == 0) AND (is_user($user))) OR ($anonpost == 1)) {
	    $db->sql_query("insert into ".$prefix."_pollcomments values (NULL, '$pid', '$pollID', now(), '$name', '$email', '$url', '$ip', '$subject', '$comment', '$score', '0')");
	    update_points(9);
	} else {
	    echo "Nice try...";
	    die();
	}
    } else {
	include("header.php");
	echo "According to my records, the topic you are trying "
	    ."to reply to does not exist. If you're just trying to be "
	    ."annoying, well then too bad.";
	include("footer.php");
	die();
    }
    if ($pollcomm == 1) {
	if (isset($userinfo['umode'])) $options .= "&mode=".$userinfo['umode']; else $options .= "&mode=thread";
	if (isset($userinfo['uorder'])) $options .= "&order=".$userinfo['uorder']; else $options .= "&order=0";
	if (isset($userinfo['thold'])) $options .= "&thold=".$userinfo['thold']; else $options .= "&thold=0";
    } else {
	$options = "";
    }
    Header("Location: modules.php?name=$module_name&op=results&pollID=$pollID$options");
}

if (isset($sid)) { $sid = intval($sid); } else { $sid = ""; }
if (isset($pollID)) { $pollID = intval($pollID); } else { $pollID = ""; }
if (isset($tid)) { $tid = intval($tid); } else { $tid = ""; }
if (isset($pid)) { $pid = intval($pid); } else { $pid = ""; }
if (isset($order)) { $order = intval($order); }
if (isset($thold)) { $thold = intval($thold); }
if (!isset($posttype)) { $posttype = ""; }

if (!isset($mode) OR empty($mode)) {
  if(isset($userinfo['umode'])) {
    $mode = $userinfo['umode'];
  } else {
    $mode = "thread";
  }
}
if (!isset($order) OR empty($order)) {
  if(isset($userinfo['uorder'])) {
    $order = $userinfo['uorder'];
  } else {
    $order = 0;
  }
}
if (!isset($thold) OR empty($thold)) {
  if(isset($userinfo['thold'])) {
    $thold = $userinfo['thold'];
  } else {
    $thold = 0;
  }
}

if (!isset($op)) { $op = ""; }
if (!isset($xanonpost)) { $xanonpost = ""; }

switch($op) {

	case "Reply":
		reply($pid, $pollID, $mode, $order, $thold);
		break;

	case ""._PREVIEW."":
		replyPreview ($pid, $pollID, $subject, $comment, $xanonpost, $mode, $order, $thold, $posttype);
		break;

	case ""._OK."":
		CreateTopic($xanonpost, $subject, $comment, $pid, $pollID, $host_name, $mode, $order, $thold, $posttype);
		break;

	case "moderate":
		global $module_name;
		if((is_admin($admin)) || ($moderate==2)) {
			while(list($tdw, $emp) = each($HTTP_POST_VARS)) {
                                $tdw = intval($tdw);
				if (stripos_clone($tdw,"dkn")) {
					$emp = explode(":", $emp);
					if($emp[1] != 0) {
						$tdw = str_replace("dkn", "", $tdw);
						$emp[0] = intval($emp[0]); 
						$emp[1] = intval($emp[1]); 
						$tdw = intval($tdw); 
						$q = "UPDATE ".$prefix."_pollcomments SET";
						if(($emp[1] == 9) && ($emp[0]>=0)) { # Overrated
							$q .= " score=score-1 where tid='$tdw'";
						} elseif (($emp[1] == 10) && ($emp[0]<=4)) { # Underrated
							$q .= " score=score+1 where tid='$tdw'";
						} elseif (($emp[1] > 4) && ($emp[0]<=4)) {
							$q .= " score='score+1', reason='$emp[1]' where tid='$tdw'";
						} elseif (($emp[1] < 5) && ($emp[0] > -1)) {
							$q .= " score='score-1', reason='$emp[1]' where tid='$tdw'";
						} elseif (($emp[0] == -1) || ($emp[0] == 5)) {
							$q .= " reason='$emp[1]' where tid='$tdw'";
						}
						if(strlen($q) > 20) $db->sql_query($q);
					}
				}
			}
		}
		Header("Location: modules.php?name=$module_name&op=results&pollID=$pollID");
		break;

	case "showreply":
		DisplayTopic($pollID, $pid, $tid, $mode, $order, $thold);
		break;

	default:
	    global $module_name, $mode, $userinfo, $order, $thold;
		if ((isset($tid)) && (!isset($pid))) {
			singlecomment($tid, $pollID, $mode, $order, $thold);
		} elseif (!isset($pid)) {
			Header("Location: modules.php?name=$module_name&op=results&pollID=$pollID&mode=$mode&order=$order&thold=$thold");
		} else {
			if(!isset($pid)) $pid=0;
			if(!isset($tid)) $tid=0;
			DisplayTopic($pollID, $pid, $tid, $mode, $order, $thold);
		}
		break;
}

?>